# 指天椒Ads SDK

## 功能特性

- 🎯 **激励视频广告** 
- 📺 **全屏视频广告** 
- 🖼️ **半屏视频广告** 
- 📍 **贴片广告** 
- 🎮 **更多游戏** 
- 📋 **隐私政策** 
- 🔄 **场景广告**

## 集成方法

### 1. 添加AAR依赖

将生成的 `htads.aar` 文件添加到你的Android项目中：

```gradle
// 在app模块的build.gradle中添加
dependencies {
    implementation files('libs/htads.aar')
}
```
### 创建AdsListener 用来接收激励视频回调结果
```java
package com.ht.adsdk.ya;

import java.util.ArrayList;

public class AdsListener {

    public static void showRewardVideoComplete(ArrayList<Object> arrayList) {
        if (arrayList == null || arrayList.size() <= 0) {
            return;
        }
        int intValue = ((Integer) arrayList.get(0)).intValue();
        if (intValue == 1) {

        }
    }

    public static void showRewardVideoFailure(ArrayList<Object> arrayList) {
        if (arrayList == null || arrayList.size() <= 0) {
            return;
        }
        int intValue = ((Integer) arrayList.get(0)).intValue();
        if (intValue == 1) {

        }
    }

}
```


## API 使用说明

### 激励视频广告

```java
import com.ht.adsdk.ya.Ads;
import java.util.ArrayList;

// 显示激励视频广告
 ArrayList<Object> arrayList = new ArrayList<>();
arrayList.add(1); //自定义参数和AdsListener对应
 Ads.showRewardVideo(arrayList);
```

**回调说明：**
- 播放成功：调用 `AdsListener.showRewardVideoComplete(ArrayList<Object> arrayList)`
- 播放失败：调用 `AdsListener.showRewardVideoFailure(ArrayList<Object> arrayList)`

### 场景广告
Ads.triggerScene("1");
## 场景说明
4 关卡结束(角色死亡)

| 场景  | 类型 | 说明 |
|-----|------|----|
| 4   | String | 关卡结束 |
| 6   | String | 游戏重开 |
| 9   | String | 游戏暂停 |
| 11  | String | 升级 |
| 13  | String | 场景切换 |
| 15  | String | 按钮设置 |


### 其他功能

```java
// 显示更多游戏
Ads.showMoreGames();

// 显示隐私政策
Ads.showPrivacyPolicy();

```
### 可以先不用
### 全屏视频广告

```java
// 显示全屏视频广告
Ads.showFullVideo();
```

### 半屏视频广告
```java
// 显示半屏视频广告
Ads.showInsert();
```

### 贴片广告

```java
import com.ht.adsdk.core.model.Position;

// 创建广告位置
Position position = new Position("center", "center", 100, 100);

// 显示贴片广告
Ads.showPatchAd(position, true);

// 关闭贴片广告
Ads.closePatchAd();

// 设置贴片广告内容
Ads.setupPatchTitleContent("广告标题", "广告内容");
```
## Position 参数说明

| 参数 | 类型 | 说明 |
|------|------|------|
| pos | String | 位置标识（如："center", "top", "bottom"） |
| align | String | 对齐方式（如："center", "left", "right"） |
| marginTop | Integer | 上边距（像素） |
| marginLeft | Integer | 左边距（像素） |

## 日志调试

SDK使用 `HTLog` 类进行日志输出，标签为 `HT_AD_HTLog`：

```java
// 在logcat中查看日志
adb logcat | grep "HT_AD_"
```
## 注意事项
1. **Unity Activity获取**：SDK会自动获取Unity的当前Activity，确保在Unity环境中使用



